/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.handler;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.client.audio.SoundPlayer;
import com.dynious.soundscool.handler.DelayedPlayHandler;
import com.dynious.soundscool.helper.NetworkHelper;
import com.dynious.soundscool.network.packet.client.CheckPresencePacket;
import com.dynious.soundscool.network.packet.server.SoundRemovedPacket;
import com.dynious.soundscool.sound.Sound;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class SoundHandler {
    private static File soundsFolder;
    private static ArrayList<Sound> sounds;

    public static File getSoundsFolder() {
        if (soundsFolder == null) {
            SoundHandler.findSounds();
        }
        return soundsFolder;
    }

    public static ArrayList<Sound> getSounds() {
        if (sounds == null) {
            SoundHandler.findSounds();
        }
        return sounds;
    }

    public static ArrayList<Sound> getLocalSounds() {
        ArrayList<Sound> localSounds = new ArrayList<Sound>();
        for (Sound sound : SoundHandler.getSounds()) {
            if (!sound.hasLocal()) continue;
            localSounds.add(sound);
        }
        return localSounds;
    }

    public static ArrayList<Sound> getRemoteSounds() {
        ArrayList<Sound> remoteSounds = new ArrayList<Sound>();
        for (Sound sound : SoundHandler.getSounds()) {
            if (!sound.hasRemote()) continue;
            remoteSounds.add(sound);
        }
        return remoteSounds;
    }

    public static Sound getSound(String fileName) {
        for (Sound sound : SoundHandler.getSounds()) {
            if (!sound.getSoundName().equals(fileName)) continue;
            return sound;
        }
        return null;
    }

    public static void findSounds() {
        soundsFolder = new File("sounds");
        if (!soundsFolder.exists()) {
            soundsFolder.mkdir();
        }
        sounds = new ArrayList();
        SoundHandler.addSoundsFromDir(soundsFolder);
    }

    public static void removeSound(Sound sound) {
        if (sound != null) {
            if (!sound.getSoundLocation().delete()) {
                sound.getSoundLocation().deleteOnExit();
            }
            sounds.remove(sound);
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                NetworkHelper.sendPacketToAll(new SoundRemovedPacket(sound.getSoundName()));
            }
        }
    }

    private static void addSoundsFromDir(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".ogg") && !file.getName().endsWith(".wav") && !file.getName().endsWith(".mp3")) continue;
                sounds.add(new Sound(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            SoundHandler.addSoundsFromDir(file);
        }
    }

    public static void addRemoteSound(String soundName, String remoteCategory) {
        Sound sound = SoundHandler.getSound(soundName);
        if (sound != null) {
            if (sound.hasLocal()) {
                sound.onSoundUploaded(remoteCategory);
            }
        } else {
            sounds.add(new Sound(soundName, remoteCategory));
        }
    }

    public static void addLocalSound(String soundName, File soundFile) {
        Sound sound = SoundHandler.getSound(soundName);
        if (sound != null) {
            if (sound.getState() != Sound.SoundState.SYNCED) {
                sound.onSoundDownloaded(soundFile);
            }
        } else {
            sounds.add(new Sound(soundFile));
        }
    }

    public static void remoteRemovedSound(Sound sound) {
        if (!sound.hasLocal()) {
            sounds.remove(sound);
        } else {
            sound.setState(Sound.SoundState.LOCAL_ONLY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSound(String soundName, String identifier, int x, int y, int z) {
        Sound sound = SoundHandler.getSound(soundName);
        if (sound.hasLocal()) {
            SoundPlayer.playSound(sound.getSoundLocation(), identifier, x, y, z, true);
        } else if (sound.getState() != Sound.SoundState.DOWNLOADING) {
            sound.setState(Sound.SoundState.DOWNLOADING);
            DelayedPlayHandler.addDelayedPlay(soundName, identifier, x, y, z);
            SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new CheckPresencePacket(soundName, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static Sound setupSound(File file) {
        File category = Minecraft.func_71410_x().func_147104_D() != null ? new File("sounds" + File.separator + Minecraft.func_71410_x().func_147104_D().field_78847_a) : new File("sounds" + File.separator + Minecraft.func_71410_x().field_71439_g.getDisplayName());
        if (!category.exists()) {
            category.mkdir();
        }
        File newFile = new File(category.getAbsolutePath() + File.separator + file.getName());
        try {
            if (!newFile.exists() || !Files.equal((File)file, (File)newFile)) {
                Files.copy((File)file, (File)newFile);
                SoundHandler.findSounds();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Sound(newFile);
    }
}

